package com.nextbiometrics.system;

import java.util.Locale;

public final class NBVersion {
    private int major;
    private int minor;
    private int build;
    private int revision;

    public NBVersion(int major, int minor, int build, int revision) {
        /* 12 */ this.major = major;
        /* 13 */ this.minor = minor;
        /* 14 */ this.build = build;
        /* 15 */ this.revision = revision;
    }

    public final int getMajor() {
        /* 19 */ return this.major;
    }

    public final int getMinor() {
        /* 23 */ return this.minor;
    }

    public final int getBuild() {
        /* 27 */ return this.build;
    }

    public final int getRevision() {
        /* 31 */ return this.revision;
    }

    public String toString() {
        /* 36 */ return String.format(Locale.getDefault(), "%d.%d.%d.%d", new Object[] { Integer.valueOf(this.major),
                Integer.valueOf(this.minor), Integer.valueOf(this.build), Integer.valueOf(this.revision) });
    }
}
