package com.nextbiometrics.system.jna;

import com.nextbiometrics.system.NBVersion;
import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
import java.util.Arrays;
import java.util.List;

public class NBVersionData extends Structure {
    public int major;
    public int minor;
    public int build;
    public int revision;

    public NBVersion toVersion() {
        /* 32 */ return new NBVersion(this.major, this.minor, this.build, this.revision);
    }

    protected List<String> getFieldOrder() {
        /* 37 */ return Arrays.asList(new String[] { "major", "minor", "build", "revision" });
    }

    public static class ByReference extends NBVersionData implements Structure.ByReference {
        public ByReference() {
            /* 12 */ this(null);
        }

        public ByReference(NBVersionData value) {
            /* 17 */ if (value != null) {
                /* 18 */ this.major = value.major;
                /* 19 */ this.minor = value.minor;
                /* 20 */ this.build = value.build;
                /* 21 */ this.revision = value.revision;
            }
        }
    }
}
