package com.nextbiometrics.system.jna.ptr;

import com.nextbiometrics.system.jna.NBSizeType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;

public class NBSizeTypeByReference extends ByReference {
    public NBSizeTypeByReference() {
        /* 10 */ this(new NBSizeType());
    }

    public NBSizeTypeByReference(NBSizeType value) {
        /* 14 */ super(Native.SIZE_T_SIZE);
        /* 15 */ setValue(value);
    }

    public void setValue(NBSizeType value) {
        /* 19 */ Pointer p = getPointer();
        /* 20 */ if (Native.SIZE_T_SIZE == 8)
            /* 21 */ p.setLong(0L, value.longValue());
        else
            /* 23 */ p.setInt(0L, value.intValue());
    }

    public NBSizeType getValue() {
        /* 28 */ Pointer p = getPointer();
        /* 29 */ return new NBSizeType(Native.SIZE_T_SIZE == 8 ? p.getLong(0L) : p.getInt(0L));
    }
}
