/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.media.browse.MediaBrowser;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.service.media.MediaBrowserService;
import android.support.v4.media.MediaBrowserServiceCompatApi21;
import android.util.Log;

class MediaBrowserServiceCompatApi23
extends MediaBrowserServiceCompatApi21 {
    private static final String TAG = "MediaBrowserServiceCompatApi21";

    MediaBrowserServiceCompatApi23() {
    }

    public static Object createService() {
        return new MediaBrowserServiceAdaptorApi23();
    }

    public static void onCreate(Object serviceObj, ServiceImplApi23 serviceImpl) {
        ((MediaBrowserServiceAdaptorApi23)serviceObj).onCreate(serviceImpl);
    }

    static class MediaBrowserServiceAdaptorApi23
    extends MediaBrowserServiceCompatApi21.MediaBrowserServiceAdaptorApi21 {
        MediaBrowserServiceAdaptorApi23() {
        }

        public void onCreate(ServiceImplApi23 serviceImpl) {
            this.mBinder = new ServiceBinderProxyApi23(serviceImpl);
        }

        private static class ServiceBinderProxyApi23
        extends MediaBrowserServiceCompatApi21.MediaBrowserServiceAdaptorApi21.ServiceBinderProxyApi21 {
            ServiceImplApi23 mServiceImpl;

            ServiceBinderProxyApi23(ServiceImplApi23 serviceImpl) {
                super(serviceImpl);
                this.mServiceImpl = serviceImpl;
            }

            @Override
            public void getMediaItem(String mediaId, final ResultReceiver receiver) {
                String KEY_MEDIA_ITEM;
                try {
                    KEY_MEDIA_ITEM = (String)MediaBrowserService.class.getDeclaredField("KEY_MEDIA_ITEM").get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    Log.i((String)MediaBrowserServiceCompatApi23.TAG, (String)"Failed to get KEY_MEDIA_ITEM via reflection", (Throwable)e);
                    return;
                }
                this.mServiceImpl.getMediaItem(mediaId, new ItemCallback(){

                    @Override
                    public void onItemLoaded(int resultCode, Bundle resultData, Parcel itemParcel) {
                        if (itemParcel != null) {
                            itemParcel.setDataPosition(0);
                            MediaBrowser.MediaItem item = (MediaBrowser.MediaItem)MediaBrowser.MediaItem.CREATOR.createFromParcel(itemParcel);
                            resultData.putParcelable(KEY_MEDIA_ITEM, (Parcelable)item);
                            itemParcel.recycle();
                        }
                        receiver.send(resultCode, resultData);
                    }
                });
            }
        }
    }

    public static interface ItemCallback {
        public void onItemLoaded(int var1, Bundle var2, Parcel var3);
    }

    public static interface ServiceImplApi23
    extends MediaBrowserServiceCompatApi21.ServiceImplApi21 {
        public void getMediaItem(String var1, ItemCallback var2);
    }
}

