package com.nextbiometrics.biometrics;

import com.nextbiometrics.biometrics.event.NBBiometricsScanPreviewListener;
import com.nextbiometrics.biometrics.jna.NBBiometricsAlgorithmInfoData;
import com.nextbiometrics.biometrics.jna.NBBiometricsIdentifyResultDetailsData;
import com.nextbiometrics.biometrics.jna.NBBiometricsScanParamsData;
import com.nextbiometrics.biometrics.jna.NBBiometricsScanPreviewCallback;
import com.nextbiometrics.biometrics.jna.NBBiometricsTemplateIterator;
import com.nextbiometrics.biometrics.jna.NBBiometricsTemplateIteratorData;
import com.nextbiometrics.biometrics.jna.NBBiometricsTemplateTypeInfoData;
import com.nextbiometrics.biometrics.jna.NBBiometricsVerifyResultDetailsData;
import com.nextbiometrics.devices.NBDevice;
import com.nextbiometrics.devices.NBDeviceScanFormat;
import com.nextbiometrics.devices.NBDeviceScanFormatInfo;
import com.nextbiometrics.system.NBCallbacks;
import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.NBObject;
import com.nextbiometrics.system.jna.NBSizeType;
import com.nextbiometrics.system.jna.NBUInt;
import com.nextbiometrics.system.jna.ptr.NBSizeTypeByReference;
import com.nextbiometrics.system.jna.ptr.NBUIntByReference;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Iterator;

public final class NBBiometricsContext extends NBObject {
    public static final int SCAN_SKIP_FINGER_NOT_REMOVED_STATUS_FLAG = 8;
    public static final int SCAN_USE_SNAPSHOT_FLAG = 16;

    private static native int NBBiometricsContextCreate(Pointer paramPointer, int paramInt,
            PointerByReference paramPointerByReference);

    private static native int NBBiometricsContextCreateWithLicense(Pointer paramPointer, byte[] paramArrayOfByte,
            NBSizeType paramNBSizeType, int paramInt, PointerByReference paramPointerByReference);

    private static native int NBBiometricsContextDestroy(Pointer paramPointer);

    private static native int NBBiometricsContextGetAlgorithmInfo(Pointer paramPointer,
            NBBiometricsAlgorithmInfoData.ByReference paramByReference);

    private static native int NBBiometricsContextSetParameter(Pointer paramPointer, int paramInt1, int paramInt2);

    private static native int NBBiometricsContextGetParameter(Pointer paramPointer, int paramInt,
            IntByReference paramIntByReference);

    private static native int NBBiometricsContextGetSecurityLevel(Pointer paramPointer, int paramInt,
            IntByReference paramIntByReference);

    private static native int NBBiometricsContextGetMaxTemplateSize(Pointer paramPointer, int paramInt,
            NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsContextIsTemplateTypeSupported(Pointer paramPointer, int paramInt,
            IntByReference paramIntByReference);

    private static native int NBBiometricsContextGetSupportedTemplateTypes(Pointer paramPointer, int[] paramArrayOfInt,
            NBUInt paramNBUInt, NBUIntByReference paramNBUIntByReference);

    private static native int NBBiometricsContextGetTemplateTypeInfo(Pointer paramPointer, int paramInt,
            NBBiometricsTemplateTypeInfoData.ByReference paramByReference);

    private static native int NBBiometricsContextConvertTemplate(Pointer paramPointer, byte[] paramArrayOfByte1,
            NBSizeType paramNBSizeType1, int paramInt1, int paramInt2, byte[] paramArrayOfByte2,
            NBSizeType paramNBSizeType2, NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsContextLoadTemplateFromMemory(Pointer paramPointer, int paramInt1,
            byte[] paramArrayOfByte1, NBSizeType paramNBSizeType1, int paramInt2, byte[] paramArrayOfByte2,
            NBSizeType paramNBSizeType2, NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsContextSaveTemplateToMemory(Pointer paramPointer, byte[] paramArrayOfByte1,
            NBSizeType paramNBSizeType1, int paramInt, byte[] paramArrayOfByte2, NBSizeType paramNBSizeType2,
            NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsContextCreateEnrollTemplateFromScan(Pointer paramPointer, int paramInt1,
            int paramInt2, NBBiometricsScanParamsData.ByReference paramByReference, int paramInt3,
            byte[] paramArrayOfByte, NBSizeType paramNBSizeType, IntByReference paramIntByReference,
            NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsContextExtractFromScan(Pointer paramPointer, int paramInt1, int paramInt2,
            NBBiometricsScanParamsData.ByReference paramByReference, int paramInt3, byte[] paramArrayOfByte,
            NBSizeType paramNBSizeType, IntByReference paramIntByReference,
            NBSizeTypeByReference paramNBSizeTypeByReference);

    private static native int NBBiometricsContextVerifyFromScan(Pointer paramPointer, int paramInt1, int paramInt2,
            NBBiometricsScanParamsData.ByReference paramByReference, byte[] paramArrayOfByte,
            NBSizeType paramNBSizeType, int paramInt3, int paramInt4, IntByReference paramIntByReference,
            NBBiometricsVerifyResultDetailsData.ByReference paramByReference1);

    private static native int NBBiometricsContextVerifyFromTemplate(Pointer paramPointer, byte[] paramArrayOfByte1,
            NBSizeType paramNBSizeType1, byte[] paramArrayOfByte2, NBSizeType paramNBSizeType2, int paramInt1,
            int paramInt2, IntByReference paramIntByReference,
            NBBiometricsVerifyResultDetailsData.ByReference paramByReference);

    private static native int NBBiometricsContextIdentifyFromScan(Pointer paramPointer, int paramInt1, int paramInt2,
            NBBiometricsScanParamsData.ByReference paramByReference,
            NBBiometricsTemplateIteratorData.ByReference paramByReference1, int paramInt3, int paramInt4,
            IntByReference paramIntByReference, NBBiometricsIdentifyResultDetailsData.ByReference paramByReference2);

    private static native int NBBiometricsContextIdentifyFromTemplate(Pointer paramPointer, byte[] paramArrayOfByte,
            NBSizeType paramNBSizeType, NBBiometricsTemplateIteratorData.ByReference paramByReference, int paramInt1,
            int paramInt2, IntByReference paramIntByReference,
            NBBiometricsIdentifyResultDetailsData.ByReference paramByReference1);

    private static native int NBBiometricsContextIsOperationRunning(Pointer paramPointer,
            IntByReference paramIntByReference);

    private static native int NBBiometricsContextCancelOperation(Pointer paramPointer);

    public NBBiometricsContext(Pointer handle, boolean ownsHandle) {
        /* 110 */ super(handle, ownsHandle);
    }

    public NBBiometricsContext(Pointer handle) {
        /* 119 */ this(handle, true);
    }

    public NBBiometricsContext(NBDevice device, long flags) {
        /* 132 */ this(create(device, flags), true);
    }

    public NBBiometricsContext(NBDevice device) {
        /* 144 */ this(device, 0L);
    }

    public NBBiometricsContext(NBDevice device, byte[] license, long flags) {
        /* 158 */ this(create(device, license, flags), true);
    }

    public NBBiometricsContext(NBDevice device, byte[] license) {
        /* 171 */ this(device, license, 0L);
    }

    public final NBBiometricsAlgorithmInfo getAlgorithmInfo() {
        /* 184 */ NBBiometricsAlgorithmInfoData.ByReference value = new NBBiometricsAlgorithmInfoData.ByReference();
        /* 185 */ NBErrors.requireNoErr(NBBiometricsContextGetAlgorithmInfo(getHandle(), value));
        /* 186 */ return new NBBiometricsAlgorithmInfo(value);
    }

    public final boolean isOperationRunning() {
        /* 195 */ IntByReference value = new IntByReference();
        /* 196 */ NBErrors.requireNoErr(NBBiometricsContextIsOperationRunning(getHandle(), value));
        /* 197 */ return value.getValue() != 0;
    }

    public final int getParameter(long parameter) {
        /* 213 */ IntByReference value = new IntByReference();
        /* 214 */ NBErrors.requireNoErr(NBBiometricsContextGetParameter(getHandle(), (int) parameter, value));
        /* 215 */ return value.getValue();
    }

    public final void setParameter(long parameter, int value) {
        /* 228 */ NBErrors.requireNoErr(NBBiometricsContextSetParameter(getHandle(), (int) parameter, value));
    }

    public final int getSecurityLevel(NBBiometricsSecurityLevel securityLevel) {
        /* 245 */ IntByReference value = new IntByReference();
        /* 246 */ NBErrors
                .requireNoErr(NBBiometricsContextGetSecurityLevel(getHandle(), securityLevel.getValue(), value));
        /* 247 */ return value.getValue();
    }

    public final boolean isTemplateTypeSupported(NBBiometricsTemplateType templateType) {
        /* 257 */ IntByReference value = new IntByReference();
        /* 258 */ NBErrors
                .requireNoErr(NBBiometricsContextIsTemplateTypeSupported(getHandle(), templateType.getValue(), value));
        /* 259 */ return value.getValue() != 0;
    }

    public NBBiometricsTemplateTypeInfo getTemplateTypeInfo(NBBiometricsTemplateType templateType) {
        /* 269 */ NBBiometricsTemplateTypeInfoData.ByReference sTemplateTypeInfo = new NBBiometricsTemplateTypeInfoData.ByReference();
        /* 270 */ NBErrors.requireNoErr(
                NBBiometricsContextGetTemplateTypeInfo(getHandle(), templateType.getValue(), sTemplateTypeInfo));
        /* 271 */ return new NBBiometricsTemplateTypeInfo(sTemplateTypeInfo);
    }

    public final NBBiometricsTemplateTypeInfo[] getSupportedTemplateTypes() {
        /* 280 */ NBUIntByReference uiCount = new NBUIntByReference();
        /* 281 */ NBErrors
                .requireNoErr(NBBiometricsContextGetSupportedTemplateTypes(getHandle(), null, new NBUInt(0L), uiCount));
        /* 282 */ if (uiCount.getValue().intValue() == 0)
            return new NBBiometricsTemplateTypeInfo[0];
        /* 283 */ int[] templateTypes = new int[uiCount.getValue().intValue()];
        /* 284 */ NBErrors.requireNoErr(NBBiometricsContextGetSupportedTemplateTypes(getHandle(), templateTypes,
                new NBUInt(templateTypes.length), uiCount));
        /* 285 */ int count = Math.min(templateTypes.length, uiCount.getValue().intValue());
        /* 286 */ NBBiometricsTemplateTypeInfo[] templateTypeInfos = new NBBiometricsTemplateTypeInfo[count];
        /* 287 */ for (int i = 0; i < count; i++) {
            /* 288 */ templateTypeInfos[i] = getTemplateTypeInfo(NBBiometricsTemplateType.get(templateTypes[i]));
        }
        /* 290 */ return templateTypeInfos;
    }

    public final NBBiometricsTemplate convertTemplate(NBBiometricsTemplate sourceTemplate,
            NBBiometricsTemplateType destinationTemplateType) {
        /* 303 */ return convertTemplate(sourceTemplate, destinationTemplateType, 0L);
    }

    public final NBBiometricsTemplate convertTemplate(NBBiometricsTemplate sourceTemplate,
            NBBiometricsTemplateType destinationTemplateType, long flags) {
        /* 317 */ NBSizeTypeByReference stSize = new NBSizeTypeByReference();
        /* 318 */ NBErrors.requireNoErr(
                NBBiometricsContextGetMaxTemplateSize(getHandle(), destinationTemplateType.getValue(), stSize));
        /* 319 */ byte[] templateData = new byte[stSize.getValue().intValue()];
        /* 320 */ NBSizeTypeByReference stActualSize = new NBSizeTypeByReference();
        /* 321 */ NBErrors.requireNoErr(NBBiometricsContextConvertTemplate(getHandle(), sourceTemplate.getData(),
                new NBSizeType(sourceTemplate.getData().length), destinationTemplateType.getValue(), (int) flags,
                templateData, new NBSizeType(templateData.length), stActualSize));

        /* 323 */ return new NBBiometricsTemplate(templateData, stSize.getValue(), stActualSize.getValue());
    }

    public final NBBiometricsTemplate loadTemplate(NBBiometricsTemplateType templateType, byte[] data) {
        /* 336 */ return loadTemplate(templateType, data, 0L);
    }

    public final NBBiometricsTemplate loadTemplate(NBBiometricsTemplateType templateType, byte[] data, long flags) {
        /* 350 */ NBSizeTypeByReference stSize = new NBSizeTypeByReference();
        /* 351 */ NBErrors
                .requireNoErr(NBBiometricsContextGetMaxTemplateSize(getHandle(), templateType.getValue(), stSize));
        /* 352 */ byte[] templateData = new byte[stSize.getValue().intValue()];
        /* 353 */ NBSizeTypeByReference stActualSize = new NBSizeTypeByReference();
        /* 354 */ NBErrors.requireNoErr(NBBiometricsContextLoadTemplateFromMemory(getHandle(), templateType.getValue(),
                data, new NBSizeType(data.length), (int) flags, templateData, new NBSizeType(templateData.length),
                stActualSize));

        /* 356 */ return new NBBiometricsTemplate(templateData, stSize.getValue(), stActualSize.getValue());
    }

    public final byte[] saveTemplate(NBBiometricsTemplate template) {
        /* 366 */ return saveTemplate(template, 0L);
    }

    public final byte[] saveTemplate(NBBiometricsTemplate template, long flags) {
        /* 377 */ NBBiometricsTemplateType templateType = template.getType();
        /* 378 */ NBSizeTypeByReference stSize = new NBSizeTypeByReference();
        /* 379 */ NBErrors
                .requireNoErr(NBBiometricsContextGetMaxTemplateSize(getHandle(), templateType.getValue(), stSize));
        /* 380 */ byte[] templateData = template.getData();
        /* 381 */ byte[] bufferData = new byte[stSize.getValue().intValue()];
        /* 382 */ NBSizeTypeByReference stActualSize = new NBSizeTypeByReference();
        /* 383 */ NBErrors.requireNoErr(
                NBBiometricsContextSaveTemplateToMemory(getHandle(), templateData, new NBSizeType(templateData.length),
                        (int) flags, bufferData, new NBSizeType(bufferData.length), stActualSize));

        /* 385 */ return Arrays.copyOf(bufferData, stActualSize.getValue().intValue());
    }

    public final void cancelOperation() {
        /* 394 */ NBErrors.requireNoErr(NBBiometricsContextCancelOperation(getHandle()));
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo) {
        /* 411 */ return createEnrollTemplate(templateType, fingerPosition, scanFormatInfo.getFormat());
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat) {
        /* 427 */ return createEnrollTemplate(templateType, fingerPosition, scanFormat, null);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsScanPreviewListener previewListener) {
        /* 444 */ return createEnrollTemplate(templateType, fingerPosition, scanFormatInfo.getFormat(),
                previewListener);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            NBBiometricsScanPreviewListener previewListener) {
        /* 461 */ return createEnrollTemplate(templateType, fingerPosition, scanFormat, -1, previewListener);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout) {
        /* 478 */ return createEnrollTemplate(templateType, fingerPosition, scanFormat, scanTimeout, null);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout) {
        /* 495 */ return createEnrollTemplate(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener) {
        /* 514 */ return createEnrollTemplate(templateType, fingerPosition, scanFormat, scanTimeout, previewListener,
                0L);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener) {
        /* 533 */ return createEnrollTemplate(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, long flags) {
        /* 553 */ return createEnrollTemplate(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener, flags);
    }

    public final NBBiometricsCreateEnrollTemplateResult createEnrollTemplate(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, long flags) {
        /* 573 */ NBSizeTypeByReference stSize = new NBSizeTypeByReference();
        /* 574 */ NBErrors
                .requireNoErr(NBBiometricsContextGetMaxTemplateSize(getHandle(), templateType.getValue(), stSize));
        /* 575 */ byte[] templateData = new byte[stSize.getValue().intValue()];
        /* 576 */ int id = NBCallbacks.add(this, previewListener);
        try {
            /* 578 */ NBBiometricsScanParamsData.ByReference psScanParams = new NBBiometricsScanParamsData.ByReference();
            /* 579 */ psScanParams.eScanFormat = scanFormat.getValue();
            /* 580 */ psScanParams.iTimeout = scanTimeout;
            /* 581 */ psScanParams.pPreviewProc = (previewListener != null
                    ? NBBiometricsScanPreviewCallback.previewCallback
                    : null);
            /* 582 */ psScanParams.pParam = new NBSizeType(id);
            /* 583 */ IntByReference eStatus = new IntByReference();
            /* 584 */ NBSizeTypeByReference stActualSize = new NBSizeTypeByReference();
            /* 585 */ NBErrors.requireNoErr(NBBiometricsContextCreateEnrollTemplateFromScan(getHandle(),
                    templateType.getValue(), fingerPosition.getValue(), psScanParams, (int) flags, templateData,
                    stSize.getValue(), eStatus, stActualSize));
            /* 586 */ NBBiometricsStatus status = NBBiometricsStatus.get(eStatus.getValue());
            /* 587 */ return status == NBBiometricsStatus.OK
                    ? new NBBiometricsCreateEnrollTemplateResult(status,
                            new NBBiometricsTemplate(templateData, stSize/* 588 */ .getValue(),
                                    stActualSize/* 589 */ .getValue()))
                    : new NBBiometricsCreateEnrollTemplateResult(status);
        } finally {
            /* 592 */ NBCallbacks.remove(id);
        }
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo) {
        /* 609 */ return extract(templateType, fingerPosition, scanFormatInfo.getFormat());
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat) {
        /* 625 */ return extract(templateType, fingerPosition, scanFormat, null);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsScanPreviewListener previewListener) {
        /* 642 */ return extract(templateType, fingerPosition, scanFormatInfo.getFormat(), previewListener);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            NBBiometricsScanPreviewListener previewListener) {
        /* 659 */ return extract(templateType, fingerPosition, scanFormat, -1, previewListener);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout) {
        /* 676 */ return extract(templateType, fingerPosition, scanFormat, scanTimeout, null);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout) {
        /* 693 */ return extract(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener) {
        /* 712 */ return extract(templateType, fingerPosition, scanFormat, scanTimeout, previewListener, 0L);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener) {
        /* 731 */ return extract(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, long flags) {
        /* 751 */ return extract(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, previewListener,
                flags);
    }

    public final NBBiometricsExtractResult extract(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, long flags) {
        /* 771 */ NBSizeTypeByReference stSize = new NBSizeTypeByReference();
        /* 772 */ NBErrors
                .requireNoErr(NBBiometricsContextGetMaxTemplateSize(getHandle(), templateType.getValue(), stSize));
        /* 773 */ byte[] templateData = new byte[stSize.getValue().intValue()];
        /* 774 */ int id = NBCallbacks.add(this, previewListener);
        try {
            /* 776 */ NBBiometricsScanParamsData.ByReference psScanParams = new NBBiometricsScanParamsData.ByReference();
            /* 777 */ psScanParams.eScanFormat = scanFormat.getValue();
            /* 778 */ psScanParams.iTimeout = scanTimeout;
            /* 779 */ psScanParams.pPreviewProc = (previewListener != null
                    ? NBBiometricsScanPreviewCallback.previewCallback
                    : null);
            /* 780 */ psScanParams.pParam = new NBSizeType(id);
            /* 781 */ IntByReference eStatus = new IntByReference();
            /* 782 */ NBSizeTypeByReference stActualSize = new NBSizeTypeByReference();
            /* 783 */ NBErrors.requireNoErr(
                    NBBiometricsContextExtractFromScan(getHandle(), templateType.getValue(), fingerPosition.getValue(),
                            psScanParams, (int) flags, templateData, stSize.getValue(), eStatus, stActualSize));
            /* 784 */ NBBiometricsStatus status = NBBiometricsStatus.get(eStatus.getValue());
            /* 785 */ return status == NBBiometricsStatus.OK
                    ? new NBBiometricsExtractResult(status,
                            new NBBiometricsTemplate(templateData, stSize/* 786 */ .getValue(),
                                    stActualSize/* 787 */ .getValue()))
                    : new NBBiometricsExtractResult(status);
        } finally {
            /* 790 */ NBCallbacks.remove(id);
        }
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel) {
        /* 810 */ return verify(templateType, fingerPosition, scanFormat, template, getSecurityLevel(securityLevel));
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsTemplate template, NBBiometricsSecurityLevel securityLevel) {
        /* 829 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), template, securityLevel);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsTemplate template, int securityLevelValue) {
        /* 848 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), template, securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, NBBiometricsTemplate template,
            int securityLevelValue) {
        /* 867 */ return verify(templateType, fingerPosition, scanFormat, -1, template, securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel) {
        /* 887 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), previewListener, template,
                securityLevel);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel) {
        /* 907 */ return verify(templateType, fingerPosition, scanFormat, previewListener, template,
                getSecurityLevel(securityLevel));
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template, int securityLevelValue) {
        /* 927 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), previewListener, template,
                securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template, int securityLevelValue) {
        /* 947 */ return verify(templateType, fingerPosition, scanFormat, -1, previewListener, template,
                securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsTemplate template, NBBiometricsSecurityLevel securityLevel) {
        /* 967 */ return verify(templateType, fingerPosition, scanFormat, scanTimeout, template,
                getSecurityLevel(securityLevel));
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsTemplate template, NBBiometricsSecurityLevel securityLevel) {
        /* 987 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, template,
                securityLevel);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsTemplate template, int securityLevelValue) {
        /* 1007 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, template,
                securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsTemplate template, int securityLevelValue) {
        /* 1027 */ return verify(templateType, fingerPosition, scanFormat, scanTimeout, null, template,
                securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1048 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, previewListener,
                template, securityLevel);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1069 */ return verify(templateType, fingerPosition, scanFormat, scanTimeout, previewListener, template,
                getSecurityLevel(securityLevel));
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template, int securityLevelValue) {
        /* 1090 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, previewListener,
                template, securityLevelValue);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template, int securityLevelValue) {
        /* 1111 */ return verify(templateType, fingerPosition, scanFormat, scanTimeout, previewListener, template,
                securityLevelValue, 0L);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel, long flags) {
        /* 1133 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, previewListener,
                template, securityLevel, flags);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template,
            NBBiometricsSecurityLevel securityLevel, long flags) {
        /* 1155 */ return verify(templateType, fingerPosition, scanFormat, scanTimeout, previewListener, template,
                getSecurityLevel(securityLevel), flags);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template, int securityLevelValue,
            long flags) {
        /* 1177 */ return verify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout, previewListener,
                template, securityLevelValue, flags);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener, NBBiometricsTemplate template, int securityLevelValue,
            long flags) {
        /* 1199 */ byte[] templateData = template.getData();
        /* 1200 */ int id = NBCallbacks.add(this, previewListener);
        try {
            /* 1202 */ NBBiometricsScanParamsData.ByReference psScanParams = new NBBiometricsScanParamsData.ByReference();
            /* 1203 */ psScanParams.eScanFormat = scanFormat.getValue();
            /* 1204 */ psScanParams.iTimeout = scanTimeout;
            /* 1205 */ psScanParams.pPreviewProc = (previewListener != null
                    ? NBBiometricsScanPreviewCallback.previewCallback
                    : null);
            /* 1206 */ psScanParams.pParam = new NBSizeType(id);

            /* 1208 */ IntByReference eStatus = new IntByReference();
            /* 1209 */ NBBiometricsVerifyResultDetailsData.ByReference sResult = new NBBiometricsVerifyResultDetailsData.ByReference();
            /* 1210 */ NBErrors.requireNoErr(NBBiometricsContextVerifyFromScan(getHandle(), templateType.getValue(),
                    fingerPosition.getValue(), psScanParams, templateData, new NBSizeType(templateData.length),
                    securityLevelValue, (int) flags, eStatus, sResult));
            /* 1211 */ return new NBBiometricsVerifyResult(NBBiometricsStatus.get(eStatus.getValue()), sResult);
        } finally {
            /* 1214 */ NBCallbacks.remove(id);
        }
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplate template, NBBiometricsTemplate otherTemplate,
            int securityLevelValue) {
        /* 1230 */ return verify(template, otherTemplate, securityLevelValue, 0L);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplate template, NBBiometricsTemplate otherTemplate,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1245 */ return verify(template, otherTemplate, getSecurityLevel(securityLevel));
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplate template, NBBiometricsTemplate otherTemplate,
            NBBiometricsSecurityLevel securityLevel, long flags) {
        /* 1261 */ return verify(template, otherTemplate, getSecurityLevel(securityLevel), flags);
    }

    public final NBBiometricsVerifyResult verify(NBBiometricsTemplate template, NBBiometricsTemplate otherTemplate,
            int securityLevelValue, long flags) {
        /* 1277 */ byte[] templateData = template.getData();
        /* 1278 */ byte[] otherTemplateData = otherTemplate.getData();
        /* 1279 */ IntByReference eStatus = new IntByReference();
        /* 1280 */ NBBiometricsVerifyResultDetailsData.ByReference sResult = new NBBiometricsVerifyResultDetailsData.ByReference();
        /* 1281 */ NBErrors.requireNoErr(NBBiometricsContextVerifyFromTemplate(getHandle(), templateData,
                new NBSizeType(templateData.length), otherTemplateData, new NBSizeType(otherTemplateData.length),
                securityLevelValue, (int) flags, eStatus, sResult));

        /* 1283 */ return new NBBiometricsVerifyResult(NBBiometricsStatus.get(eStatus.getValue()), sResult);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1301 */ return identify(templateType, fingerPosition, scanFormat, otherTemplates,
                getSecurityLevel(securityLevel));
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1319 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), otherTemplates,
                securityLevel);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1337 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), otherTemplates,
                securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1355 */ return identify(templateType, fingerPosition, scanFormat, null, otherTemplates, securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1374 */ return identify(templateType, fingerPosition, scanFormat, scanTimeout, otherTemplates,
                getSecurityLevel(securityLevel));
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1393 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                otherTemplates, securityLevel);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1412 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                otherTemplates, securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1431 */ return identify(templateType, fingerPosition, scanFormat, scanTimeout, null, otherTemplates,
                securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1450 */ return identify(templateType, fingerPosition, scanFormat, previewListener, otherTemplates,
                getSecurityLevel(securityLevel));
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1469 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), previewListener,
                otherTemplates, securityLevel);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1488 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), previewListener,
                otherTemplates, securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1507 */ return identify(templateType, fingerPosition, scanFormat, -1, previewListener, otherTemplates,
                securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1527 */ return identify(templateType, fingerPosition, scanFormat, scanTimeout, previewListener,
                otherTemplates, getSecurityLevel(securityLevel));
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1547 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener, otherTemplates, securityLevel);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1567 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener, otherTemplates, securityLevelValue);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1587 */ return identify(templateType, fingerPosition, scanFormat, scanTimeout, previewListener,
                otherTemplates, securityLevelValue, 0L);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel, long flags) {
        /* 1608 */ return identify(templateType, fingerPosition, scanFormat, scanTimeout, previewListener,
                otherTemplates, getSecurityLevel(securityLevel), flags);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel, long flags) {
        /* 1629 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener, otherTemplates, securityLevel, flags);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormatInfo scanFormatInfo, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue,
            long flags) {
        /* 1650 */ return identify(templateType, fingerPosition, scanFormatInfo.getFormat(), scanTimeout,
                previewListener, otherTemplates, securityLevelValue, flags);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplateType templateType,
            NBBiometricsFingerPosition fingerPosition, NBDeviceScanFormat scanFormat, int scanTimeout,
            NBBiometricsScanPreviewListener previewListener,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue,
            long flags) {
        /* 1671 */ int id = NBCallbacks.add(this, previewListener);
        try {
            /* 1673 */ NBBiometricsScanParamsData.ByReference psScanParams = new NBBiometricsScanParamsData.ByReference();
            /* 1674 */ psScanParams.eScanFormat = scanFormat.getValue();
            /* 1675 */ psScanParams.iTimeout = scanTimeout;
            /* 1676 */ psScanParams.pPreviewProc = (previewListener != null
                    ? NBBiometricsScanPreviewCallback.previewCallback
                    : null);
            /* 1677 */ psScanParams.pParam = new NBSizeType(id);
            /* 1678 */ NBBiometricsTemplateIterator iterator = new NBBiometricsTemplateIterator(otherTemplates);
            /* 1679 */ NBBiometricsTemplateIteratorData.ByReference psIterator = new NBBiometricsTemplateIteratorData.ByReference(
                    iterator);
            /* 1680 */ IntByReference peStatus = new IntByReference();
            /* 1681 */ NBBiometricsIdentifyResultDetailsData.ByReference psResult = new NBBiometricsIdentifyResultDetailsData.ByReference();
            /* 1682 */ NBErrors.requireNoErr(
                    NBBiometricsContextIdentifyFromScan(getHandle(), templateType.getValue(), fingerPosition.getValue(),
                            psScanParams, psIterator, securityLevelValue, (int) flags, peStatus, psResult));
            /* 1683 */ return new NBBiometricsIdentifyResult(NBBiometricsStatus.get(peStatus.getValue()),
                    iterator.getTemplateId(psResult.pTemplateId), psResult);
        } finally {
            /* 1686 */ NBCallbacks.remove(id);
        }
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplate template,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel) {
        /* 1703 */ return identify(template, otherTemplates, getSecurityLevel(securityLevel));
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplate template,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue) {
        /* 1719 */ return identify(template, otherTemplates, securityLevelValue, 0L);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplate template,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates,
            NBBiometricsSecurityLevel securityLevel, long flags) {
        /* 1736 */ return identify(template, otherTemplates, getSecurityLevel(securityLevel), flags);
    }

    public final NBBiometricsIdentifyResult identify(NBBiometricsTemplate template,
            Iterator<AbstractMap.SimpleEntry<Object, NBBiometricsTemplate>> otherTemplates, int securityLevelValue,
            long flags) {
        /* 1753 */ byte[] templateData = template.getData();
        /* 1754 */ NBBiometricsTemplateIterator iterator = new NBBiometricsTemplateIterator(otherTemplates);
        /* 1755 */ NBBiometricsTemplateIteratorData.ByReference psIterator = new NBBiometricsTemplateIteratorData.ByReference(
                iterator);
        /* 1756 */ IntByReference peStatus = new IntByReference();
        /* 1757 */ NBBiometricsIdentifyResultDetailsData.ByReference psResult = new NBBiometricsIdentifyResultDetailsData.ByReference();
        /* 1758 */ NBErrors.requireNoErr(NBBiometricsContextIdentifyFromTemplate(getHandle(), templateData,
                new NBSizeType(templateData.length), psIterator, securityLevelValue, (int) flags, peStatus, psResult));

        /* 1760 */ return new NBBiometricsIdentifyResult(NBBiometricsStatus.get(peStatus.getValue()),
                iterator.getTemplateId(psResult.pTemplateId), psResult);
    }

    private static final Pointer create(NBDevice device, long flags) {
        /* 1768 */ PointerByReference pPtr = new PointerByReference();
        /* 1769 */ NBErrors.requireNoErr(NBBiometricsContextCreate(device.getHandle(), (int) flags, pPtr));
        /* 1770 */ return pPtr.getValue();
    }

    private static final Pointer create(NBDevice device, byte[] license, long flags) {
        /* 1774 */ PointerByReference pPtr = new PointerByReference();
        /* 1775 */ NBErrors.requireNoErr(NBBiometricsContextCreateWithLicense(device.getHandle(), license,
                new NBSizeType(license.length), (int) flags, pPtr));
        /* 1776 */ return pPtr.getValue();
    }

    protected void dispose(boolean disposing) {
        /* 1785 */ if ((getOwnsHandle()) && (getHandle() != null))
            /* 1786 */ NBErrors.requireNoErr(NBBiometricsContextDestroy(getHandle()));
    }

    static {
        /* 96 */ Native.register(NBBiometricsContext.class, NBBiometricsLibrary.NATIVE_LIBRARY);
    }
}
