package com.nextbiometrics.devices;

import java.util.EnumSet;

public enum NBDeviceConnectionType {
    /* 12 */ UNKNOWN(0),

    /* 16 */ USB(1),

    /* 20 */ SPI(2),

    /* 24 */ UART(3),

    /* 28 */ BLUETOOTH(4);

    private int value;

    private NBDeviceConnectionType(int value) {
        /* 41 */ this.value = value;
    }

    public static final NBDeviceConnectionType get(int value) {
        /* 49 */ for (NBDeviceConnectionType v : EnumSet.allOf(NBDeviceConnectionType.class)) {
            /* 50 */ if (value == v.getValue())
                /* 51 */ return v;
        }
        /* 53 */ throw new IllegalArgumentException("value is an unknown NBDeviceConnectionType value");
    }

    public final int getValue() {
        /* 61 */ return this.value;
    }
}
