package com.nextbiometrics.devices.jna;

import com.nextbiometrics.devices.NBDevice;
import com.nextbiometrics.devices.NBDeviceScanFormatInfo;
import com.nextbiometrics.devices.NBDeviceScanStatus;
import com.nextbiometrics.devices.NBDevicesLibrary;
import com.nextbiometrics.devices.event.NBDeviceScanPreviewEvent;
import com.nextbiometrics.devices.event.NBDeviceScanPreviewListener;
import com.nextbiometrics.system.NBCallback;
import com.nextbiometrics.system.NBCallbackParam;
import com.nextbiometrics.system.NBCallbacks;
import com.nextbiometrics.system.NBErrors;
import com.nextbiometrics.system.jna.NBSizeType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class NBDeviceScanPreviewCallback {
    /* 27 */ public static final NBDeviceScanPreviewProc previewCallback = new NBDeviceScanPreviewProc() {
        public int invoke(Pointer hDevice, IntByReference peStatus, Pointer psScanFormat, Pointer pBuffer,
                NBSizeType stBufferSize, Pointer psDetails, NBSizeType pParam) {
            try {
                /* 31 */ NBDeviceScanFormatInfoData scanFormatInfo = new NBDeviceScanFormatInfoData(psScanFormat);
                /* 32 */ NBDeviceScanPreviewDetailsData previewDetails = new NBDeviceScanPreviewDetailsData(psDetails);
                /* 33 */ NBCallbackParam param = NBCallbacks.get(pParam.intValue());

                /* 36 */ NBDeviceScanPreviewEvent event = new NBDeviceScanPreviewEvent(new NBDevice(hDevice, false),
                        NBDeviceScanStatus.get(peStatus.getValue()), new NBDeviceScanFormatInfo(scanFormatInfo),
                        pBuffer/* 36 */ .getByteArray(0L, stBufferSize/* 36 */ .intValue()),
                        previewDetails.iFingerDetectValue);
                /* 37 */ ((NBDeviceScanPreviewListener) param.getListener()).preview(event);
                /* 38 */ peStatus.setValue(event.getStatus().getValue());
                /* 39 */ return 0;
            } catch (Throwable th) {
                /* 41 */ return NBErrors.setLast(th);
            }
        }
        /* 27 */ };

    static {
        /* 20 */ Native.register(NBDeviceScanPreviewCallback.class, NBDevicesLibrary.NATIVE_LIBRARY);
    }

    public static abstract interface NBDeviceScanPreviewProc extends NBCallback {
        public abstract int invoke(Pointer paramPointer1, IntByReference paramIntByReference, Pointer paramPointer2,
                Pointer paramPointer3, NBSizeType paramNBSizeType1, Pointer paramPointer4, NBSizeType paramNBSizeType2);
    }
}
